# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class RoomMeta(object):
    _types = {
        "name": str,
        "room_id": str,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.room_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RoomMetaBuilder":
        return RoomMetaBuilder()


class RoomMetaBuilder(object):
    def __init__(self) -> None:
        self._room_meta = RoomMeta()

    def name(self, name: str) -> "RoomMetaBuilder":
        self._room_meta.name = name
        return self

    def room_id(self, room_id: str) -> "RoomMetaBuilder":
        self._room_meta.room_id = room_id
        return self

    def build(self) -> "RoomMeta":
        return self._room_meta
