# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .calendar import Calendar


class SearchCalendarResponseBody(object):
    _types = {
        "items": List[Calendar],
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Calendar]] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchCalendarResponseBodyBuilder":
        return SearchCalendarResponseBodyBuilder()


class SearchCalendarResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_calendar_response_body = SearchCalendarResponseBody()

    def items(self, items: List[Calendar]) -> "SearchCalendarResponseBodyBuilder":
        self._search_calendar_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "SearchCalendarResponseBodyBuilder":
        self._search_calendar_response_body.page_token = page_token
        return self

    def build(self) -> "SearchCalendarResponseBody":
        return self._search_calendar_response_body
