# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .user_meta import UserMeta


class SearchUserDataAi(object):
    _types = {
        "query_keyword": str,
        "user_info": UserMeta,
    }

    def __init__(self, d=None):
        self.query_keyword: Optional[str] = None
        self.user_info: Optional[UserMeta] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchUserDataAiBuilder":
        return SearchUserDataAiBuilder()


class SearchUserDataAiBuilder(object):
    def __init__(self) -> None:
        self._search_user_data_ai = SearchUserDataAi()

    def query_keyword(self, query_keyword: str) -> "SearchUserDataAiBuilder":
        self._search_user_data_ai.query_keyword = query_keyword
        return self

    def user_info(self, user_info: UserMeta) -> "SearchUserDataAiBuilder":
        self._search_user_data_ai.user_info = user_info
        return self

    def build(self) -> "SearchUserDataAi":
        return self._search_user_data_ai
