# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class SubscribeCalendarRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.calendar_id: Optional[str] = None

    @staticmethod
    def builder() -> "SubscribeCalendarRequestBuilder":
        return SubscribeCalendarRequestBuilder()


class SubscribeCalendarRequestBuilder(object):

    def __init__(self) -> None:
        subscribe_calendar_request = SubscribeCalendarRequest()
        subscribe_calendar_request.http_method = HttpMethod.POST
        subscribe_calendar_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/subscribe"
        subscribe_calendar_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._subscribe_calendar_request: SubscribeCalendarRequest = subscribe_calendar_request

    def calendar_id(self, calendar_id: str) -> "SubscribeCalendarRequestBuilder":
        self._subscribe_calendar_request.calendar_id = calendar_id
        self._subscribe_calendar_request.paths["calendar_id"] = str(calendar_id)
        return self

    def build(self) -> SubscribeCalendarRequest:
        return self._subscribe_calendar_request
