# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TimeInfo(object):
    _types = {
        "date": str,
        "timestamp": str,
        "timezone": str,
    }

    def __init__(self, d=None):
        self.date: Optional[str] = None
        self.timestamp: Optional[str] = None
        self.timezone: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TimeInfoBuilder":
        return TimeInfoBuilder()


class TimeInfoBuilder(object):
    def __init__(self) -> None:
        self._time_info = TimeInfo()

    def date(self, date: str) -> "TimeInfoBuilder":
        self._time_info.date = date
        return self

    def timestamp(self, timestamp: str) -> "TimeInfoBuilder":
        self._time_info.timestamp = timestamp
        return self

    def timezone(self, timezone: str) -> "TimeInfoBuilder":
        self._time_info.timezone = timezone
        return self

    def build(self) -> "TimeInfo":
        return self._time_info
