# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class UnsubscribeCalendarRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.calendar_id: Optional[str] = None

    @staticmethod
    def builder() -> "UnsubscribeCalendarRequestBuilder":
        return UnsubscribeCalendarRequestBuilder()


class UnsubscribeCalendarRequestBuilder(object):

    def __init__(self) -> None:
        unsubscribe_calendar_request = UnsubscribeCalendarRequest()
        unsubscribe_calendar_request.http_method = HttpMethod.POST
        unsubscribe_calendar_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/unsubscribe"
        unsubscribe_calendar_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._unsubscribe_calendar_request: UnsubscribeCalendarRequest = unsubscribe_calendar_request

    def calendar_id(self, calendar_id: str) -> "UnsubscribeCalendarRequestBuilder":
        self._unsubscribe_calendar_request.calendar_id = calendar_id
        self._unsubscribe_calendar_request.paths["calendar_id"] = str(calendar_id)
        return self

    def build(self) -> UnsubscribeCalendarRequest:
        return self._unsubscribe_calendar_request
