# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class UnsubscriptionCalendarAclRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.calendar_id: Optional[str] = None

    @staticmethod
    def builder() -> "UnsubscriptionCalendarAclRequestBuilder":
        return UnsubscriptionCalendarAclRequestBuilder()


class UnsubscriptionCalendarAclRequestBuilder(object):

    def __init__(self) -> None:
        unsubscription_calendar_acl_request = UnsubscriptionCalendarAclRequest()
        unsubscription_calendar_acl_request.http_method = HttpMethod.POST
        unsubscription_calendar_acl_request.uri = "/open-apis/calendar/v4/calendars/:calendar_id/acls/unsubscription"
        unsubscription_calendar_acl_request.token_types = {AccessTokenType.USER}
        self._unsubscription_calendar_acl_request: UnsubscriptionCalendarAclRequest = unsubscription_calendar_acl_request

    def calendar_id(self, calendar_id: str) -> "UnsubscriptionCalendarAclRequestBuilder":
        self._unsubscription_calendar_acl_request.calendar_id = calendar_id
        self._unsubscription_calendar_acl_request.paths["calendar_id"] = str(calendar_id)
        return self

    def build(self) -> UnsubscriptionCalendarAclRequest:
        return self._unsubscription_calendar_acl_request
