# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class UserMeta(object):
    _types = {
        "name": str,
        "user_id": str,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.user_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserMetaBuilder":
        return UserMetaBuilder()


class UserMetaBuilder(object):
    def __init__(self) -> None:
        self._user_meta = UserMeta()

    def name(self, name: str) -> "UserMetaBuilder":
        self._user_meta.name = name
        return self

    def user_id(self, user_id: str) -> "UserMetaBuilder":
        self._user_meta.user_id = user_id
        return self

    def build(self) -> "UserMeta":
        return self._user_meta
