# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_calendar_request import CreateCalendarRequest
from ..model.create_calendar_response import CreateCalendarResponse
from ..model.delete_calendar_request import DeleteCalendarRequest
from ..model.delete_calendar_response import DeleteCalendarResponse
from ..model.get_calendar_request import GetCalendarRequest
from ..model.get_calendar_response import GetCalendarResponse
from ..model.list_calendar_request import ListCalendarRequest
from ..model.list_calendar_response import ListCalendarResponse
from ..model.patch_calendar_request import PatchCalendarRequest
from ..model.patch_calendar_response import PatchCalendarResponse
from ..model.primary_calendar_request import PrimaryCalendarRequest
from ..model.primary_calendar_response import PrimaryCalendarResponse
from ..model.search_calendar_request import SearchCalendarRequest
from ..model.search_calendar_response import SearchCalendarResponse
from ..model.subscribe_calendar_request import SubscribeCalendarRequest
from ..model.subscribe_calendar_response import SubscribeCalendarResponse
from ..model.subscription_calendar_request import SubscriptionCalendarRequest
from ..model.subscription_calendar_response import SubscriptionCalendarResponse
from ..model.unsubscribe_calendar_request import UnsubscribeCalendarRequest
from ..model.unsubscribe_calendar_response import UnsubscribeCalendarResponse
from ..model.unsubscription_calendar_request import UnsubscriptionCalendarRequest
from ..model.unsubscription_calendar_response import UnsubscriptionCalendarResponse


class Calendar(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateCalendarRequest, option: Optional[RequestOption] = None) -> CreateCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateCalendarResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateCalendarRequest,
                      option: Optional[RequestOption] = None) -> CreateCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateCalendarResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteCalendarRequest, option: Optional[RequestOption] = None) -> DeleteCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteCalendarResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteCalendarRequest,
                      option: Optional[RequestOption] = None) -> DeleteCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteCalendarResponse)
        response.raw = resp

        return response

    def get(self, request: GetCalendarRequest, option: Optional[RequestOption] = None) -> GetCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), GetCalendarResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetCalendarRequest, option: Optional[RequestOption] = None) -> GetCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), GetCalendarResponse)
        response.raw = resp

        return response

    def list(self, request: ListCalendarRequest, option: Optional[RequestOption] = None) -> ListCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), ListCalendarResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListCalendarRequest, option: Optional[RequestOption] = None) -> ListCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), ListCalendarResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchCalendarRequest, option: Optional[RequestOption] = None) -> PatchCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchCalendarResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchCalendarRequest,
                     option: Optional[RequestOption] = None) -> PatchCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchCalendarResponse)
        response.raw = resp

        return response

    def primary(self, request: PrimaryCalendarRequest,
                option: Optional[RequestOption] = None) -> PrimaryCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PrimaryCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), PrimaryCalendarResponse)
        response.raw = resp

        return response

    async def aprimary(self, request: PrimaryCalendarRequest,
                       option: Optional[RequestOption] = None) -> PrimaryCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PrimaryCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), PrimaryCalendarResponse)
        response.raw = resp

        return response

    def search(self, request: SearchCalendarRequest, option: Optional[RequestOption] = None) -> SearchCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SearchCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchCalendarResponse)
        response.raw = resp

        return response

    async def asearch(self, request: SearchCalendarRequest,
                      option: Optional[RequestOption] = None) -> SearchCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SearchCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchCalendarResponse)
        response.raw = resp

        return response

    def subscribe(self, request: SubscribeCalendarRequest,
                  option: Optional[RequestOption] = None) -> SubscribeCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SubscribeCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), SubscribeCalendarResponse)
        response.raw = resp

        return response

    async def asubscribe(self, request: SubscribeCalendarRequest,
                         option: Optional[RequestOption] = None) -> SubscribeCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SubscribeCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), SubscribeCalendarResponse)
        response.raw = resp

        return response

    def subscription(self, request: SubscriptionCalendarRequest,
                     option: Optional[RequestOption] = None) -> SubscriptionCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SubscriptionCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), SubscriptionCalendarResponse)
        response.raw = resp

        return response

    async def asubscription(self, request: SubscriptionCalendarRequest,
                            option: Optional[RequestOption] = None) -> SubscriptionCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SubscriptionCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), SubscriptionCalendarResponse)
        response.raw = resp

        return response

    def unsubscribe(self, request: UnsubscribeCalendarRequest,
                    option: Optional[RequestOption] = None) -> UnsubscribeCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UnsubscribeCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), UnsubscribeCalendarResponse)
        response.raw = resp

        return response

    async def aunsubscribe(self, request: UnsubscribeCalendarRequest,
                           option: Optional[RequestOption] = None) -> UnsubscribeCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UnsubscribeCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8), UnsubscribeCalendarResponse)
        response.raw = resp

        return response

    def unsubscription(self, request: UnsubscriptionCalendarRequest,
                       option: Optional[RequestOption] = None) -> UnsubscriptionCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UnsubscriptionCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  UnsubscriptionCalendarResponse)
        response.raw = resp

        return response

    async def aunsubscription(self, request: UnsubscriptionCalendarRequest,
                              option: Optional[RequestOption] = None) -> UnsubscriptionCalendarResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UnsubscriptionCalendarResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  UnsubscriptionCalendarResponse)
        response.raw = resp

        return response
