# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class BatchDepartmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.department_ids: Optional[List[str]] = None
        self.department_id_type: Optional[str] = None
        self.user_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "BatchDepartmentRequestBuilder":
        return BatchDepartmentRequestBuilder()


class BatchDepartmentRequestBuilder(object):

    def __init__(self) -> None:
        batch_department_request = BatchDepartmentRequest()
        batch_department_request.http_method = HttpMethod.GET
        batch_department_request.uri = "/open-apis/contact/v3/departments/batch"
        batch_department_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._batch_department_request: BatchDepartmentRequest = batch_department_request

    def department_ids(self, department_ids: List[str]) -> "BatchDepartmentRequestBuilder":
        self._batch_department_request.department_ids = department_ids
        self._batch_department_request.add_query("department_ids", department_ids)
        return self

    def department_id_type(self, department_id_type: str) -> "BatchDepartmentRequestBuilder":
        self._batch_department_request.department_id_type = department_id_type
        self._batch_department_request.add_query("department_id_type", department_id_type)
        return self

    def user_id_type(self, user_id_type: str) -> "BatchDepartmentRequestBuilder":
        self._batch_department_request.user_id_type = user_id_type
        self._batch_department_request.add_query("user_id_type", user_id_type)
        return self

    def build(self) -> BatchDepartmentRequest:
        return self._batch_department_request
