# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class BatchUserRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_ids: Optional[List[str]] = None
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "BatchUserRequestBuilder":
        return BatchUserRequestBuilder()


class BatchUserRequestBuilder(object):

    def __init__(self) -> None:
        batch_user_request = BatchUserRequest()
        batch_user_request.http_method = HttpMethod.GET
        batch_user_request.uri = "/open-apis/contact/v3/users/batch"
        batch_user_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._batch_user_request: BatchUserRequest = batch_user_request

    def user_ids(self, user_ids: List[str]) -> "BatchUserRequestBuilder":
        self._batch_user_request.user_ids = user_ids
        self._batch_user_request.add_query("user_ids", user_ids)
        return self

    def user_id_type(self, user_id_type: str) -> "BatchUserRequestBuilder":
        self._batch_user_request.user_id_type = user_id_type
        self._batch_user_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "BatchUserRequestBuilder":
        self._batch_user_request.department_id_type = department_id_type
        self._batch_user_request.add_query("department_id_type", department_id_type)
        return self

    def build(self) -> BatchUserRequest:
        return self._batch_user_request
