# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .bind_department_unit_request_body import BindDepartmentUnitRequestBody


class BindDepartmentUnitRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[BindDepartmentUnitRequestBody] = None

    @staticmethod
    def builder() -> "BindDepartmentUnitRequestBuilder":
        return BindDepartmentUnitRequestBuilder()


class BindDepartmentUnitRequestBuilder(object):

    def __init__(self) -> None:
        bind_department_unit_request = BindDepartmentUnitRequest()
        bind_department_unit_request.http_method = HttpMethod.POST
        bind_department_unit_request.uri = "/open-apis/contact/v3/unit/bind_department"
        bind_department_unit_request.token_types = {AccessTokenType.TENANT}
        self._bind_department_unit_request: BindDepartmentUnitRequest = bind_department_unit_request

    def request_body(self, request_body: BindDepartmentUnitRequestBody) -> "BindDepartmentUnitRequestBuilder":
        self._bind_department_unit_request.request_body = request_body
        self._bind_department_unit_request.body = request_body
        return self

    def build(self) -> BindDepartmentUnitRequest:
        return self._bind_department_unit_request
