# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ChildrenDepartmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.fetch_child: Optional[bool] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.department_id: Optional[int] = None

    @staticmethod
    def builder() -> "ChildrenDepartmentRequestBuilder":
        return ChildrenDepartmentRequestBuilder()


class ChildrenDepartmentRequestBuilder(object):

    def __init__(self) -> None:
        children_department_request = ChildrenDepartmentRequest()
        children_department_request.http_method = HttpMethod.GET
        children_department_request.uri = "/open-apis/contact/v3/departments/:department_id/children"
        children_department_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._children_department_request: ChildrenDepartmentRequest = children_department_request

    def user_id_type(self, user_id_type: str) -> "ChildrenDepartmentRequestBuilder":
        self._children_department_request.user_id_type = user_id_type
        self._children_department_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "ChildrenDepartmentRequestBuilder":
        self._children_department_request.department_id_type = department_id_type
        self._children_department_request.add_query("department_id_type", department_id_type)
        return self

    def fetch_child(self, fetch_child: bool) -> "ChildrenDepartmentRequestBuilder":
        self._children_department_request.fetch_child = fetch_child
        self._children_department_request.add_query("fetch_child", fetch_child)
        return self

    def page_size(self, page_size: int) -> "ChildrenDepartmentRequestBuilder":
        self._children_department_request.page_size = page_size
        self._children_department_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ChildrenDepartmentRequestBuilder":
        self._children_department_request.page_token = page_token
        self._children_department_request.add_query("page_token", page_token)
        return self

    def department_id(self, department_id: int) -> "ChildrenDepartmentRequestBuilder":
        self._children_department_request.department_id = department_id
        self._children_department_request.paths["department_id"] = str(department_id)
        return self

    def build(self) -> ChildrenDepartmentRequest:
        return self._children_department_request
