# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .avatar_info import AvatarInfo


class CollaborationTenant(object):
    _types = {
        "tenant_key": str,
        "name": str,
        "nickname": str,
        "connect_time": int,
        "avatar": AvatarInfo,
        "brand": str,
    }

    def __init__(self, d=None):
        self.tenant_key: Optional[str] = None
        self.name: Optional[str] = None
        self.nickname: Optional[str] = None
        self.connect_time: Optional[int] = None
        self.avatar: Optional[AvatarInfo] = None
        self.brand: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CollaborationTenantBuilder":
        return CollaborationTenantBuilder()


class CollaborationTenantBuilder(object):
    def __init__(self) -> None:
        self._collaboration_tenant = CollaborationTenant()

    def tenant_key(self, tenant_key: str) -> "CollaborationTenantBuilder":
        self._collaboration_tenant.tenant_key = tenant_key
        return self

    def name(self, name: str) -> "CollaborationTenantBuilder":
        self._collaboration_tenant.name = name
        return self

    def nickname(self, nickname: str) -> "CollaborationTenantBuilder":
        self._collaboration_tenant.nickname = nickname
        return self

    def connect_time(self, connect_time: int) -> "CollaborationTenantBuilder":
        self._collaboration_tenant.connect_time = connect_time
        return self

    def avatar(self, avatar: AvatarInfo) -> "CollaborationTenantBuilder":
        self._collaboration_tenant.avatar = avatar
        return self

    def brand(self, brand: str) -> "CollaborationTenantBuilder":
        self._collaboration_tenant.brand = brand
        return self

    def build(self) -> "CollaborationTenant":
        return self._collaboration_tenant
