# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ConfidentialMember(object):
    _types = {
        "user_id": int,
        "is_confidential": bool,
    }

    def __init__(self, d=None):
        self.user_id: Optional[int] = None
        self.is_confidential: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ConfidentialMemberBuilder":
        return ConfidentialMemberBuilder()


class ConfidentialMemberBuilder(object):
    def __init__(self) -> None:
        self._confidential_member = ConfidentialMember()

    def user_id(self, user_id: int) -> "ConfidentialMemberBuilder":
        self._confidential_member.user_id = user_id
        return self

    def is_confidential(self, is_confidential: bool) -> "ConfidentialMemberBuilder":
        self._confidential_member.is_confidential = is_confidential
        return self

    def build(self) -> "ConfidentialMember":
        return self._confidential_member
