# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .department import Department


class CreateDepartmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.client_token: Optional[str] = None
        self.request_body: Optional[Department] = None

    @staticmethod
    def builder() -> "CreateDepartmentRequestBuilder":
        return CreateDepartmentRequestBuilder()


class CreateDepartmentRequestBuilder(object):

    def __init__(self) -> None:
        create_department_request = CreateDepartmentRequest()
        create_department_request.http_method = HttpMethod.POST
        create_department_request.uri = "/open-apis/contact/v3/departments"
        create_department_request.token_types = {AccessTokenType.TENANT}
        self._create_department_request: CreateDepartmentRequest = create_department_request

    def user_id_type(self, user_id_type: str) -> "CreateDepartmentRequestBuilder":
        self._create_department_request.user_id_type = user_id_type
        self._create_department_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "CreateDepartmentRequestBuilder":
        self._create_department_request.department_id_type = department_id_type
        self._create_department_request.add_query("department_id_type", department_id_type)
        return self

    def client_token(self, client_token: str) -> "CreateDepartmentRequestBuilder":
        self._create_department_request.client_token = client_token
        self._create_department_request.add_query("client_token", client_token)
        return self

    def request_body(self, request_body: Department) -> "CreateDepartmentRequestBuilder":
        self._create_department_request.request_body = request_body
        self._create_department_request.body = request_body
        return self

    def build(self) -> CreateDepartmentRequest:
        return self._create_department_request
