# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_functional_role_request_body import CreateFunctionalRoleRequestBody


class CreateFunctionalRoleRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreateFunctionalRoleRequestBody] = None

    @staticmethod
    def builder() -> "CreateFunctionalRoleRequestBuilder":
        return CreateFunctionalRoleRequestBuilder()


class CreateFunctionalRoleRequestBuilder(object):

    def __init__(self) -> None:
        create_functional_role_request = CreateFunctionalRoleRequest()
        create_functional_role_request.http_method = HttpMethod.POST
        create_functional_role_request.uri = "/open-apis/contact/v3/functional_roles"
        create_functional_role_request.token_types = {AccessTokenType.TENANT}
        self._create_functional_role_request: CreateFunctionalRoleRequest = create_functional_role_request

    def request_body(self, request_body: CreateFunctionalRoleRequestBody) -> "CreateFunctionalRoleRequestBuilder":
        self._create_functional_role_request.request_body = request_body
        self._create_functional_role_request.body = request_body
        return self

    def build(self) -> CreateFunctionalRoleRequest:
        return self._create_functional_role_request
