# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .custom_attr_options import CustomAttrOptions
from .i18n_content import I18nContent


class CustomAttr(object):
    _types = {
        "id": str,
        "type": str,
        "options": CustomAttrOptions,
        "i18n_name": List[I18nContent],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.options: Optional[CustomAttrOptions] = None
        self.i18n_name: Optional[List[I18nContent]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CustomAttrBuilder":
        return CustomAttrBuilder()


class CustomAttrBuilder(object):
    def __init__(self) -> None:
        self._custom_attr = CustomAttr()

    def id(self, id: str) -> "CustomAttrBuilder":
        self._custom_attr.id = id
        return self

    def type(self, type: str) -> "CustomAttrBuilder":
        self._custom_attr.type = type
        return self

    def options(self, options: CustomAttrOptions) -> "CustomAttrBuilder":
        self._custom_attr.options = options
        return self

    def i18n_name(self, i18n_name: List[I18nContent]) -> "CustomAttrBuilder":
        self._custom_attr.i18n_name = i18n_name
        return self

    def build(self) -> "CustomAttr":
        return self._custom_attr
