# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .department_i18n_name import DepartmentI18nName


class DepartmentPathName(object):
    _types = {
        "name": str,
        "i18n_name": DepartmentI18nName,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.i18n_name: Optional[DepartmentI18nName] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DepartmentPathNameBuilder":
        return DepartmentPathNameBuilder()


class DepartmentPathNameBuilder(object):
    def __init__(self) -> None:
        self._department_path_name = DepartmentPathName()

    def name(self, name: str) -> "DepartmentPathNameBuilder":
        self._department_path_name.name = name
        return self

    def i18n_name(self, i18n_name: DepartmentI18nName) -> "DepartmentPathNameBuilder":
        self._department_path_name.i18n_name = i18n_name
        return self

    def build(self) -> "DepartmentPathName":
        return self._department_path_name
