# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class DynamicGroupExpression(object):
    _types = {
        "field": str,
        "operator": str,
        "value": str,
        "values": List[str],
    }

    def __init__(self, d=None):
        self.field: Optional[str] = None
        self.operator: Optional[str] = None
        self.value: Optional[str] = None
        self.values: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DynamicGroupExpressionBuilder":
        return DynamicGroupExpressionBuilder()


class DynamicGroupExpressionBuilder(object):
    def __init__(self) -> None:
        self._dynamic_group_expression = DynamicGroupExpression()

    def field(self, field: str) -> "DynamicGroupExpressionBuilder":
        self._dynamic_group_expression.field = field
        return self

    def operator(self, operator: str) -> "DynamicGroupExpressionBuilder":
        self._dynamic_group_expression.operator = operator
        return self

    def value(self, value: str) -> "DynamicGroupExpressionBuilder":
        self._dynamic_group_expression.value = value
        return self

    def values(self, values: List[str]) -> "DynamicGroupExpressionBuilder":
        self._dynamic_group_expression.values = values
        return self

    def build(self) -> "DynamicGroupExpression":
        return self._dynamic_group_expression
