# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .dynamic_group_expression import DynamicGroupExpression


class DynamicGroupRule(object):
    _types = {
        "department_level": str,
        "expressions": List[DynamicGroupExpression],
        "joiner_rule": str,
        "group_status": str,
    }

    def __init__(self, d=None):
        self.department_level: Optional[str] = None
        self.expressions: Optional[List[DynamicGroupExpression]] = None
        self.joiner_rule: Optional[str] = None
        self.group_status: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DynamicGroupRuleBuilder":
        return DynamicGroupRuleBuilder()


class DynamicGroupRuleBuilder(object):
    def __init__(self) -> None:
        self._dynamic_group_rule = DynamicGroupRule()

    def department_level(self, department_level: str) -> "DynamicGroupRuleBuilder":
        self._dynamic_group_rule.department_level = department_level
        return self

    def expressions(self, expressions: List[DynamicGroupExpression]) -> "DynamicGroupRuleBuilder":
        self._dynamic_group_rule.expressions = expressions
        return self

    def joiner_rule(self, joiner_rule: str) -> "DynamicGroupRuleBuilder":
        self._dynamic_group_rule.joiner_rule = joiner_rule
        return self

    def group_status(self, group_status: str) -> "DynamicGroupRuleBuilder":
        self._dynamic_group_rule.group_status = group_status
        return self

    def build(self) -> "DynamicGroupRule":
        return self._dynamic_group_rule
