# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n_content import I18nContent


class EmployeeTypeEnum(object):
    _types = {
        "enum_id": str,
        "enum_value": int,
        "content": str,
        "enum_type": int,
        "enum_status": int,
        "i18n_content": List[I18nContent],
    }

    def __init__(self, d=None):
        self.enum_id: Optional[str] = None
        self.enum_value: Optional[int] = None
        self.content: Optional[str] = None
        self.enum_type: Optional[int] = None
        self.enum_status: Optional[int] = None
        self.i18n_content: Optional[List[I18nContent]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EmployeeTypeEnumBuilder":
        return EmployeeTypeEnumBuilder()


class EmployeeTypeEnumBuilder(object):
    def __init__(self) -> None:
        self._employee_type_enum = EmployeeTypeEnum()

    def enum_id(self, enum_id: str) -> "EmployeeTypeEnumBuilder":
        self._employee_type_enum.enum_id = enum_id
        return self

    def enum_value(self, enum_value: int) -> "EmployeeTypeEnumBuilder":
        self._employee_type_enum.enum_value = enum_value
        return self

    def content(self, content: str) -> "EmployeeTypeEnumBuilder":
        self._employee_type_enum.content = content
        return self

    def enum_type(self, enum_type: int) -> "EmployeeTypeEnumBuilder":
        self._employee_type_enum.enum_type = enum_type
        return self

    def enum_status(self, enum_status: int) -> "EmployeeTypeEnumBuilder":
        self._employee_type_enum.enum_status = enum_status
        return self

    def i18n_content(self, i18n_content: List[I18nContent]) -> "EmployeeTypeEnumBuilder":
        self._employee_type_enum.i18n_content = i18n_content
        return self

    def build(self) -> "EmployeeTypeEnum":
        return self._employee_type_enum
