# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class FunctionalRole(object):
    _types = {
        "role_id": str,
        "role_name": str,
    }

    def __init__(self, d=None):
        self.role_id: Optional[str] = None
        self.role_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FunctionalRoleBuilder":
        return FunctionalRoleBuilder()


class FunctionalRoleBuilder(object):
    def __init__(self) -> None:
        self._functional_role = FunctionalRole()

    def role_id(self, role_id: str) -> "FunctionalRoleBuilder":
        self._functional_role.role_id = role_id
        return self

    def role_name(self, role_name: str) -> "FunctionalRoleBuilder":
        self._functional_role.role_name = role_name
        return self

    def build(self) -> "FunctionalRole":
        return self._functional_role
