# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class FunctionalRoleMember(object):
    _types = {
        "user_id": str,
        "scope_type": str,
        "department_ids": List[str],
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.scope_type: Optional[str] = None
        self.department_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FunctionalRoleMemberBuilder":
        return FunctionalRoleMemberBuilder()


class FunctionalRoleMemberBuilder(object):
    def __init__(self) -> None:
        self._functional_role_member = FunctionalRoleMember()

    def user_id(self, user_id: str) -> "FunctionalRoleMemberBuilder":
        self._functional_role_member.user_id = user_id
        return self

    def scope_type(self, scope_type: str) -> "FunctionalRoleMemberBuilder":
        self._functional_role_member.scope_type = scope_type
        return self

    def department_ids(self, department_ids: List[str]) -> "FunctionalRoleMemberBuilder":
        self._functional_role_member.department_ids = department_ids
        return self

    def build(self) -> "FunctionalRoleMember":
        return self._functional_role_member
