# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetJobLevelRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.job_level_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetJobLevelRequestBuilder":
        return GetJobLevelRequestBuilder()


class GetJobLevelRequestBuilder(object):

    def __init__(self) -> None:
        get_job_level_request = GetJobLevelRequest()
        get_job_level_request.http_method = HttpMethod.GET
        get_job_level_request.uri = "/open-apis/contact/v3/job_levels/:job_level_id"
        get_job_level_request.token_types = {AccessTokenType.TENANT}
        self._get_job_level_request: GetJobLevelRequest = get_job_level_request

    def job_level_id(self, job_level_id: str) -> "GetJobLevelRequestBuilder":
        self._get_job_level_request.job_level_id = job_level_id
        self._get_job_level_request.paths["job_level_id"] = str(job_level_id)
        return self

    def build(self) -> GetJobLevelRequest:
        return self._get_job_level_request
