# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetUnitRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.unit_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetUnitRequestBuilder":
        return GetUnitRequestBuilder()


class GetUnitRequestBuilder(object):

    def __init__(self) -> None:
        get_unit_request = GetUnitRequest()
        get_unit_request.http_method = HttpMethod.GET
        get_unit_request.uri = "/open-apis/contact/v3/unit/:unit_id"
        get_unit_request.token_types = {AccessTokenType.TENANT}
        self._get_unit_request: GetUnitRequest = get_unit_request

    def unit_id(self, unit_id: str) -> "GetUnitRequestBuilder":
        self._get_unit_request.unit_id = unit_id
        self._get_unit_request.paths["unit_id"] = str(unit_id)
        return self

    def build(self) -> GetUnitRequest:
        return self._get_unit_request
