# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Group(object):
    _types = {
        "id": str,
        "name": str,
        "description": str,
        "member_user_count": int,
        "member_department_count": int,
        "type": int,
        "group_id": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.member_user_count: Optional[int] = None
        self.member_department_count: Optional[int] = None
        self.type: Optional[int] = None
        self.group_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GroupBuilder":
        return GroupBuilder()


class GroupBuilder(object):
    def __init__(self) -> None:
        self._group = Group()

    def id(self, id: str) -> "GroupBuilder":
        self._group.id = id
        return self

    def name(self, name: str) -> "GroupBuilder":
        self._group.name = name
        return self

    def description(self, description: str) -> "GroupBuilder":
        self._group.description = description
        return self

    def member_user_count(self, member_user_count: int) -> "GroupBuilder":
        self._group.member_user_count = member_user_count
        return self

    def member_department_count(self, member_department_count: int) -> "GroupBuilder":
        self._group.member_department_count = member_department_count
        return self

    def type(self, type: int) -> "GroupBuilder":
        self._group.type = type
        return self

    def group_id(self, group_id: str) -> "GroupBuilder":
        self._group.group_id = group_id
        return self

    def build(self) -> "Group":
        return self._group
