# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class GroupVisibleScope(object):
    _types = {
        "visible_scope_type": str,
        "visible_users": List[str],
        "visible_departments": List[str],
        "scene_types": List[int],
    }

    def __init__(self, d=None):
        self.visible_scope_type: Optional[str] = None
        self.visible_users: Optional[List[str]] = None
        self.visible_departments: Optional[List[str]] = None
        self.scene_types: Optional[List[int]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GroupVisibleScopeBuilder":
        return GroupVisibleScopeBuilder()


class GroupVisibleScopeBuilder(object):
    def __init__(self) -> None:
        self._group_visible_scope = GroupVisibleScope()

    def visible_scope_type(self, visible_scope_type: str) -> "GroupVisibleScopeBuilder":
        self._group_visible_scope.visible_scope_type = visible_scope_type
        return self

    def visible_users(self, visible_users: List[str]) -> "GroupVisibleScopeBuilder":
        self._group_visible_scope.visible_users = visible_users
        return self

    def visible_departments(self, visible_departments: List[str]) -> "GroupVisibleScopeBuilder":
        self._group_visible_scope.visible_departments = visible_departments
        return self

    def scene_types(self, scene_types: List[int]) -> "GroupVisibleScopeBuilder":
        self._group_visible_scope.scene_types = scene_types
        return self

    def build(self) -> "GroupVisibleScope":
        return self._group_visible_scope
