# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n_content import I18nContent


class JobTitle(object):
    _types = {
        "job_title_id": str,
        "name": str,
        "i18n_name": List[I18nContent],
        "status": bool,
    }

    def __init__(self, d=None):
        self.job_title_id: Optional[str] = None
        self.name: Optional[str] = None
        self.i18n_name: Optional[List[I18nContent]] = None
        self.status: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobTitleBuilder":
        return JobTitleBuilder()


class JobTitleBuilder(object):
    def __init__(self) -> None:
        self._job_title = JobTitle()

    def job_title_id(self, job_title_id: str) -> "JobTitleBuilder":
        self._job_title.job_title_id = job_title_id
        return self

    def name(self, name: str) -> "JobTitleBuilder":
        self._job_title.name = name
        return self

    def i18n_name(self, i18n_name: List[I18nContent]) -> "JobTitleBuilder":
        self._job_title.i18n_name = i18n_name
        return self

    def status(self, status: bool) -> "JobTitleBuilder":
        self._job_title.status = status
        return self

    def build(self) -> "JobTitle":
        return self._job_title
