# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListCustomAttrRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListCustomAttrRequestBuilder":
        return ListCustomAttrRequestBuilder()


class ListCustomAttrRequestBuilder(object):

    def __init__(self) -> None:
        list_custom_attr_request = ListCustomAttrRequest()
        list_custom_attr_request.http_method = HttpMethod.GET
        list_custom_attr_request.uri = "/open-apis/contact/v3/custom_attrs"
        list_custom_attr_request.token_types = {AccessTokenType.TENANT}
        self._list_custom_attr_request: ListCustomAttrRequest = list_custom_attr_request

    def page_size(self, page_size: int) -> "ListCustomAttrRequestBuilder":
        self._list_custom_attr_request.page_size = page_size
        self._list_custom_attr_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListCustomAttrRequestBuilder":
        self._list_custom_attr_request.page_token = page_token
        self._list_custom_attr_request.add_query("page_token", page_token)
        return self

    def build(self) -> ListCustomAttrRequest:
        return self._list_custom_attr_request
