# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListDepartmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.parent_department_id: Optional[str] = None
        self.fetch_child: Optional[bool] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListDepartmentRequestBuilder":
        return ListDepartmentRequestBuilder()


class ListDepartmentRequestBuilder(object):

    def __init__(self) -> None:
        list_department_request = ListDepartmentRequest()
        list_department_request.http_method = HttpMethod.GET
        list_department_request.uri = "/open-apis/contact/v3/departments"
        list_department_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_department_request: ListDepartmentRequest = list_department_request

    def user_id_type(self, user_id_type: str) -> "ListDepartmentRequestBuilder":
        self._list_department_request.user_id_type = user_id_type
        self._list_department_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "ListDepartmentRequestBuilder":
        self._list_department_request.department_id_type = department_id_type
        self._list_department_request.add_query("department_id_type", department_id_type)
        return self

    def parent_department_id(self, parent_department_id: str) -> "ListDepartmentRequestBuilder":
        self._list_department_request.parent_department_id = parent_department_id
        self._list_department_request.add_query("parent_department_id", parent_department_id)
        return self

    def fetch_child(self, fetch_child: bool) -> "ListDepartmentRequestBuilder":
        self._list_department_request.fetch_child = fetch_child
        self._list_department_request.add_query("fetch_child", fetch_child)
        return self

    def page_size(self, page_size: int) -> "ListDepartmentRequestBuilder":
        self._list_department_request.page_size = page_size
        self._list_department_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListDepartmentRequestBuilder":
        self._list_department_request.page_token = page_token
        self._list_department_request.add_query("page_token", page_token)
        return self

    def build(self) -> ListDepartmentRequest:
        return self._list_department_request
