# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListScopeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None

    @staticmethod
    def builder() -> "ListScopeRequestBuilder":
        return ListScopeRequestBuilder()


class ListScopeRequestBuilder(object):

    def __init__(self) -> None:
        list_scope_request = ListScopeRequest()
        list_scope_request.http_method = HttpMethod.GET
        list_scope_request.uri = "/open-apis/contact/v3/scopes"
        list_scope_request.token_types = {AccessTokenType.TENANT}
        self._list_scope_request: ListScopeRequest = list_scope_request

    def user_id_type(self, user_id_type: str) -> "ListScopeRequestBuilder":
        self._list_scope_request.user_id_type = user_id_type
        self._list_scope_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "ListScopeRequestBuilder":
        self._list_scope_request.department_id_type = department_id_type
        self._list_scope_request.add_query("department_id_type", department_id_type)
        return self

    def page_token(self, page_token: str) -> "ListScopeRequestBuilder":
        self._list_scope_request.page_token = page_token
        self._list_scope_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListScopeRequestBuilder":
        self._list_scope_request.page_size = page_size
        self._list_scope_request.add_query("page_size", page_size)
        return self

    def build(self) -> ListScopeRequest:
        return self._list_scope_request
