# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class ListScopeResponseBody(object):
    _types = {
        "department_ids": List[str],
        "user_ids": List[str],
        "group_ids": List[str],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.department_ids: Optional[List[str]] = None
        self.user_ids: Optional[List[str]] = None
        self.group_ids: Optional[List[str]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListScopeResponseBodyBuilder":
        return ListScopeResponseBodyBuilder()


class ListScopeResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_scope_response_body = ListScopeResponseBody()

    def department_ids(self, department_ids: List[str]) -> "ListScopeResponseBodyBuilder":
        self._list_scope_response_body.department_ids = department_ids
        return self

    def user_ids(self, user_ids: List[str]) -> "ListScopeResponseBodyBuilder":
        self._list_scope_response_body.user_ids = user_ids
        return self

    def group_ids(self, group_ids: List[str]) -> "ListScopeResponseBodyBuilder":
        self._list_scope_response_body.group_ids = group_ids
        return self

    def has_more(self, has_more: bool) -> "ListScopeResponseBodyBuilder":
        self._list_scope_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListScopeResponseBodyBuilder":
        self._list_scope_response_body.page_token = page_token
        return self

    def build(self) -> "ListScopeResponseBody":
        return self._list_scope_response_body
