# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListUnitRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListUnitRequestBuilder":
        return ListUnitRequestBuilder()


class ListUnitRequestBuilder(object):

    def __init__(self) -> None:
        list_unit_request = ListUnitRequest()
        list_unit_request.http_method = HttpMethod.GET
        list_unit_request.uri = "/open-apis/contact/v3/unit"
        list_unit_request.token_types = {AccessTokenType.TENANT}
        self._list_unit_request: ListUnitRequest = list_unit_request

    def page_size(self, page_size: int) -> "ListUnitRequestBuilder":
        self._list_unit_request.page_size = page_size
        self._list_unit_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListUnitRequestBuilder":
        self._list_unit_request.page_token = page_token
        self._list_unit_request.add_query("page_token", page_token)
        return self

    def build(self) -> ListUnitRequest:
        return self._list_unit_request
