# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .unit import Unit


class ListUnitResponseBody(object):
    _types = {
        "unitlist": List[Unit],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.unitlist: Optional[List[Unit]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListUnitResponseBodyBuilder":
        return ListUnitResponseBodyBuilder()


class ListUnitResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_unit_response_body = ListUnitResponseBody()

    def unitlist(self, unitlist: List[Unit]) -> "ListUnitResponseBodyBuilder":
        self._list_unit_response_body.unitlist = unitlist
        return self

    def has_more(self, has_more: bool) -> "ListUnitResponseBodyBuilder":
        self._list_unit_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListUnitResponseBodyBuilder":
        self._list_unit_response_body.page_token = page_token
        return self

    def build(self) -> "ListUnitResponseBody":
        return self._list_unit_response_body
