# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .user import User


class ListUserResponseBody(object):
    _types = {
        "has_more": bool,
        "page_token": str,
        "items": List[User],
    }

    def __init__(self, d=None):
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.items: Optional[List[User]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListUserResponseBodyBuilder":
        return ListUserResponseBodyBuilder()


class ListUserResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_user_response_body = ListUserResponseBody()

    def has_more(self, has_more: bool) -> "ListUserResponseBodyBuilder":
        self._list_user_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListUserResponseBodyBuilder":
        self._list_user_response_body.page_token = page_token
        return self

    def items(self, items: List[User]) -> "ListUserResponseBodyBuilder":
        self._list_user_response_body.items = items
        return self

    def build(self) -> "ListUserResponseBody":
        return self._list_user_response_body
