# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .department_status import DepartmentStatus


class OldDepartmentObject(object):
    _types = {
        "status": DepartmentStatus,
        "open_department_id": str,
    }

    def __init__(self, d=None):
        self.status: Optional[DepartmentStatus] = None
        self.open_department_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OldDepartmentObjectBuilder":
        return OldDepartmentObjectBuilder()


class OldDepartmentObjectBuilder(object):
    def __init__(self) -> None:
        self._old_department_object = OldDepartmentObject()

    def status(self, status: DepartmentStatus) -> "OldDepartmentObjectBuilder":
        self._old_department_object.status = status
        return self

    def open_department_id(self, open_department_id: str) -> "OldDepartmentObjectBuilder":
        self._old_department_object.open_department_id = open_department_id
        return self

    def build(self) -> "OldDepartmentObject":
        return self._old_department_object
