# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .remove_group_member_request_body import RemoveGroupMemberRequestBody


class RemoveGroupMemberRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.group_id: Optional[str] = None
        self.request_body: Optional[RemoveGroupMemberRequestBody] = None

    @staticmethod
    def builder() -> "RemoveGroupMemberRequestBuilder":
        return RemoveGroupMemberRequestBuilder()


class RemoveGroupMemberRequestBuilder(object):

    def __init__(self) -> None:
        remove_group_member_request = RemoveGroupMemberRequest()
        remove_group_member_request.http_method = HttpMethod.POST
        remove_group_member_request.uri = "/open-apis/contact/v3/group/:group_id/member/remove"
        remove_group_member_request.token_types = {AccessTokenType.TENANT}
        self._remove_group_member_request: RemoveGroupMemberRequest = remove_group_member_request

    def group_id(self, group_id: str) -> "RemoveGroupMemberRequestBuilder":
        self._remove_group_member_request.group_id = group_id
        self._remove_group_member_request.paths["group_id"] = str(group_id)
        return self

    def request_body(self, request_body: RemoveGroupMemberRequestBody) -> "RemoveGroupMemberRequestBuilder":
        self._remove_group_member_request.request_body = request_body
        self._remove_group_member_request.body = request_body
        return self

    def build(self) -> RemoveGroupMemberRequest:
        return self._remove_group_member_request
