# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ResourceAcceptor(object):
    _types = {
        "processing_type": int,
        "acceptor_user_id": int,
    }

    def __init__(self, d=None):
        self.processing_type: Optional[int] = None
        self.acceptor_user_id: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ResourceAcceptorBuilder":
        return ResourceAcceptorBuilder()


class ResourceAcceptorBuilder(object):
    def __init__(self) -> None:
        self._resource_acceptor = ResourceAcceptor()

    def processing_type(self, processing_type: int) -> "ResourceAcceptorBuilder":
        self._resource_acceptor.processing_type = processing_type
        return self

    def acceptor_user_id(self, acceptor_user_id: int) -> "ResourceAcceptorBuilder":
        self._resource_acceptor.acceptor_user_id = acceptor_user_id
        return self

    def build(self) -> "ResourceAcceptor":
        return self._resource_acceptor
