# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .user_department_info import UserDepartmentInfo


class ResurrectUserRequestBody(object):
    _types = {
        "departments": List[UserDepartmentInfo],
        "subscription_ids": List[int],
    }

    def __init__(self, d=None):
        self.departments: Optional[List[UserDepartmentInfo]] = None
        self.subscription_ids: Optional[List[int]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ResurrectUserRequestBodyBuilder":
        return ResurrectUserRequestBodyBuilder()


class ResurrectUserRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._resurrect_user_request_body = ResurrectUserRequestBody()

    def departments(self, departments: List[UserDepartmentInfo]) -> "ResurrectUserRequestBodyBuilder":
        self._resurrect_user_request_body.departments = departments
        return self

    def subscription_ids(self, subscription_ids: List[int]) -> "ResurrectUserRequestBodyBuilder":
        self._resurrect_user_request_body.subscription_ids = subscription_ids
        return self

    def build(self) -> "ResurrectUserRequestBody":
        return self._resurrect_user_request_body
