# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .department_i18n_name import DepartmentI18nName


class ShareDepartment(object):
    _types = {
        "open_id": str,
        "name": str,
        "i18n_name": DepartmentI18nName,
        "order": str,
    }

    def __init__(self, d=None):
        self.open_id: Optional[str] = None
        self.name: Optional[str] = None
        self.i18n_name: Optional[DepartmentI18nName] = None
        self.order: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ShareDepartmentBuilder":
        return ShareDepartmentBuilder()


class ShareDepartmentBuilder(object):
    def __init__(self) -> None:
        self._share_department = ShareDepartment()

    def open_id(self, open_id: str) -> "ShareDepartmentBuilder":
        self._share_department.open_id = open_id
        return self

    def name(self, name: str) -> "ShareDepartmentBuilder":
        self._share_department.name = name
        return self

    def i18n_name(self, i18n_name: DepartmentI18nName) -> "ShareDepartmentBuilder":
        self._share_department.i18n_name = i18n_name
        return self

    def order(self, order: str) -> "ShareDepartmentBuilder":
        self._share_department.order = order
        return self

    def build(self) -> "ShareDepartment":
        return self._share_department
