# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class SimplelistGroupMemberRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.member_id_type: Optional[str] = None
        self.member_type: Optional[str] = None
        self.group_id: Optional[str] = None

    @staticmethod
    def builder() -> "SimplelistGroupMemberRequestBuilder":
        return SimplelistGroupMemberRequestBuilder()


class SimplelistGroupMemberRequestBuilder(object):

    def __init__(self) -> None:
        simplelist_group_member_request = SimplelistGroupMemberRequest()
        simplelist_group_member_request.http_method = HttpMethod.GET
        simplelist_group_member_request.uri = "/open-apis/contact/v3/group/:group_id/member/simplelist"
        simplelist_group_member_request.token_types = {AccessTokenType.TENANT}
        self._simplelist_group_member_request: SimplelistGroupMemberRequest = simplelist_group_member_request

    def page_size(self, page_size: int) -> "SimplelistGroupMemberRequestBuilder":
        self._simplelist_group_member_request.page_size = page_size
        self._simplelist_group_member_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "SimplelistGroupMemberRequestBuilder":
        self._simplelist_group_member_request.page_token = page_token
        self._simplelist_group_member_request.add_query("page_token", page_token)
        return self

    def member_id_type(self, member_id_type: str) -> "SimplelistGroupMemberRequestBuilder":
        self._simplelist_group_member_request.member_id_type = member_id_type
        self._simplelist_group_member_request.add_query("member_id_type", member_id_type)
        return self

    def member_type(self, member_type: str) -> "SimplelistGroupMemberRequestBuilder":
        self._simplelist_group_member_request.member_type = member_type
        self._simplelist_group_member_request.add_query("member_type", member_type)
        return self

    def group_id(self, group_id: str) -> "SimplelistGroupMemberRequestBuilder":
        self._simplelist_group_member_request.group_id = group_id
        self._simplelist_group_member_request.paths["group_id"] = str(group_id)
        return self

    def build(self) -> SimplelistGroupMemberRequest:
        return self._simplelist_group_member_request
