# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .unbind_department_chat_department_request_body import UnbindDepartmentChatDepartmentRequestBody


class UnbindDepartmentChatDepartmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.department_id_type: Optional[str] = None
        self.request_body: Optional[UnbindDepartmentChatDepartmentRequestBody] = None

    @staticmethod
    def builder() -> "UnbindDepartmentChatDepartmentRequestBuilder":
        return UnbindDepartmentChatDepartmentRequestBuilder()


class UnbindDepartmentChatDepartmentRequestBuilder(object):

    def __init__(self) -> None:
        unbind_department_chat_department_request = UnbindDepartmentChatDepartmentRequest()
        unbind_department_chat_department_request.http_method = HttpMethod.POST
        unbind_department_chat_department_request.uri = "/open-apis/contact/v3/departments/unbind_department_chat"
        unbind_department_chat_department_request.token_types = {AccessTokenType.TENANT}
        self._unbind_department_chat_department_request: UnbindDepartmentChatDepartmentRequest = unbind_department_chat_department_request

    def department_id_type(self, department_id_type: str) -> "UnbindDepartmentChatDepartmentRequestBuilder":
        self._unbind_department_chat_department_request.department_id_type = department_id_type
        self._unbind_department_chat_department_request.add_query("department_id_type", department_id_type)
        return self

    def request_body(self,
                     request_body: UnbindDepartmentChatDepartmentRequestBody) -> "UnbindDepartmentChatDepartmentRequestBuilder":
        self._unbind_department_chat_department_request.request_body = request_body
        self._unbind_department_chat_department_request.body = request_body
        return self

    def build(self) -> UnbindDepartmentChatDepartmentRequest:
        return self._unbind_department_chat_department_request
