# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .update_department_id_department_request_body import UpdateDepartmentIdDepartmentRequestBody


class UpdateDepartmentIdDepartmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.department_id_type: Optional[str] = None
        self.department_id: Optional[str] = None
        self.request_body: Optional[UpdateDepartmentIdDepartmentRequestBody] = None

    @staticmethod
    def builder() -> "UpdateDepartmentIdDepartmentRequestBuilder":
        return UpdateDepartmentIdDepartmentRequestBuilder()


class UpdateDepartmentIdDepartmentRequestBuilder(object):

    def __init__(self) -> None:
        update_department_id_department_request = UpdateDepartmentIdDepartmentRequest()
        update_department_id_department_request.http_method = HttpMethod.PATCH
        update_department_id_department_request.uri = "/open-apis/contact/v3/departments/:department_id/update_department_id"
        update_department_id_department_request.token_types = {AccessTokenType.TENANT}
        self._update_department_id_department_request: UpdateDepartmentIdDepartmentRequest = update_department_id_department_request

    def department_id_type(self, department_id_type: str) -> "UpdateDepartmentIdDepartmentRequestBuilder":
        self._update_department_id_department_request.department_id_type = department_id_type
        self._update_department_id_department_request.add_query("department_id_type", department_id_type)
        return self

    def department_id(self, department_id: str) -> "UpdateDepartmentIdDepartmentRequestBuilder":
        self._update_department_id_department_request.department_id = department_id
        self._update_department_id_department_request.paths["department_id"] = str(department_id)
        return self

    def request_body(self,
                     request_body: UpdateDepartmentIdDepartmentRequestBody) -> "UpdateDepartmentIdDepartmentRequestBuilder":
        self._update_department_id_department_request.request_body = request_body
        self._update_department_id_department_request.body = request_body
        return self

    def build(self) -> UpdateDepartmentIdDepartmentRequest:
        return self._update_department_id_department_request
