# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class UserDepartmentInfo(object):
    _types = {
        "department_id": int,
        "user_order": int,
        "department_order": int,
    }

    def __init__(self, d=None):
        self.department_id: Optional[int] = None
        self.user_order: Optional[int] = None
        self.department_order: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserDepartmentInfoBuilder":
        return UserDepartmentInfoBuilder()


class UserDepartmentInfoBuilder(object):
    def __init__(self) -> None:
        self._user_department_info = UserDepartmentInfo()

    def department_id(self, department_id: int) -> "UserDepartmentInfoBuilder":
        self._user_department_info.department_id = department_id
        return self

    def user_order(self, user_order: int) -> "UserDepartmentInfoBuilder":
        self._user_department_info.user_order = user_order
        return self

    def department_order(self, department_order: int) -> "UserDepartmentInfoBuilder":
        self._user_department_info.department_order = department_order
        return self

    def build(self) -> "UserDepartmentInfo":
        return self._user_department_info
