# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .avatar_info import AvatarInfo
from .user_custom_attr import UserCustomAttr
from .user_order import UserOrder
from .user_status import UserStatus


class UserEvent(object):
    _types = {
        "open_id": str,
        "union_id": str,
        "user_id": str,
        "name": str,
        "en_name": str,
        "nickname": str,
        "email": str,
        "enterprise_email": str,
        "job_title": str,
        "mobile": str,
        "gender": int,
        "avatar": AvatarInfo,
        "status": UserStatus,
        "department_ids": List[str],
        "leader_user_id": str,
        "city": str,
        "country": str,
        "work_station": str,
        "join_time": int,
        "employee_no": str,
        "employee_type": int,
        "orders": List[UserOrder],
        "custom_attrs": List[UserCustomAttr],
        "job_level_id": str,
        "job_family_id": str,
        "dotted_line_leader_user_ids": List[int],
    }

    def __init__(self, d=None):
        self.open_id: Optional[str] = None
        self.union_id: Optional[str] = None
        self.user_id: Optional[str] = None
        self.name: Optional[str] = None
        self.en_name: Optional[str] = None
        self.nickname: Optional[str] = None
        self.email: Optional[str] = None
        self.enterprise_email: Optional[str] = None
        self.job_title: Optional[str] = None
        self.mobile: Optional[str] = None
        self.gender: Optional[int] = None
        self.avatar: Optional[AvatarInfo] = None
        self.status: Optional[UserStatus] = None
        self.department_ids: Optional[List[str]] = None
        self.leader_user_id: Optional[str] = None
        self.city: Optional[str] = None
        self.country: Optional[str] = None
        self.work_station: Optional[str] = None
        self.join_time: Optional[int] = None
        self.employee_no: Optional[str] = None
        self.employee_type: Optional[int] = None
        self.orders: Optional[List[UserOrder]] = None
        self.custom_attrs: Optional[List[UserCustomAttr]] = None
        self.job_level_id: Optional[str] = None
        self.job_family_id: Optional[str] = None
        self.dotted_line_leader_user_ids: Optional[List[int]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserEventBuilder":
        return UserEventBuilder()


class UserEventBuilder(object):
    def __init__(self) -> None:
        self._user_event = UserEvent()

    def open_id(self, open_id: str) -> "UserEventBuilder":
        self._user_event.open_id = open_id
        return self

    def union_id(self, union_id: str) -> "UserEventBuilder":
        self._user_event.union_id = union_id
        return self

    def user_id(self, user_id: str) -> "UserEventBuilder":
        self._user_event.user_id = user_id
        return self

    def name(self, name: str) -> "UserEventBuilder":
        self._user_event.name = name
        return self

    def en_name(self, en_name: str) -> "UserEventBuilder":
        self._user_event.en_name = en_name
        return self

    def nickname(self, nickname: str) -> "UserEventBuilder":
        self._user_event.nickname = nickname
        return self

    def email(self, email: str) -> "UserEventBuilder":
        self._user_event.email = email
        return self

    def enterprise_email(self, enterprise_email: str) -> "UserEventBuilder":
        self._user_event.enterprise_email = enterprise_email
        return self

    def job_title(self, job_title: str) -> "UserEventBuilder":
        self._user_event.job_title = job_title
        return self

    def mobile(self, mobile: str) -> "UserEventBuilder":
        self._user_event.mobile = mobile
        return self

    def gender(self, gender: int) -> "UserEventBuilder":
        self._user_event.gender = gender
        return self

    def avatar(self, avatar: AvatarInfo) -> "UserEventBuilder":
        self._user_event.avatar = avatar
        return self

    def status(self, status: UserStatus) -> "UserEventBuilder":
        self._user_event.status = status
        return self

    def department_ids(self, department_ids: List[str]) -> "UserEventBuilder":
        self._user_event.department_ids = department_ids
        return self

    def leader_user_id(self, leader_user_id: str) -> "UserEventBuilder":
        self._user_event.leader_user_id = leader_user_id
        return self

    def city(self, city: str) -> "UserEventBuilder":
        self._user_event.city = city
        return self

    def country(self, country: str) -> "UserEventBuilder":
        self._user_event.country = country
        return self

    def work_station(self, work_station: str) -> "UserEventBuilder":
        self._user_event.work_station = work_station
        return self

    def join_time(self, join_time: int) -> "UserEventBuilder":
        self._user_event.join_time = join_time
        return self

    def employee_no(self, employee_no: str) -> "UserEventBuilder":
        self._user_event.employee_no = employee_no
        return self

    def employee_type(self, employee_type: int) -> "UserEventBuilder":
        self._user_event.employee_type = employee_type
        return self

    def orders(self, orders: List[UserOrder]) -> "UserEventBuilder":
        self._user_event.orders = orders
        return self

    def custom_attrs(self, custom_attrs: List[UserCustomAttr]) -> "UserEventBuilder":
        self._user_event.custom_attrs = custom_attrs
        return self

    def job_level_id(self, job_level_id: str) -> "UserEventBuilder":
        self._user_event.job_level_id = job_level_id
        return self

    def job_family_id(self, job_family_id: str) -> "UserEventBuilder":
        self._user_event.job_family_id = job_family_id
        return self

    def dotted_line_leader_user_ids(self, dotted_line_leader_user_ids: List[int]) -> "UserEventBuilder":
        self._user_event.dotted_line_leader_user_ids = dotted_line_leader_user_ids
        return self

    def build(self) -> "UserEvent":
        return self._user_event
