# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_functional_role_request import CreateFunctionalRoleRequest
from ..model.create_functional_role_response import CreateFunctionalRoleResponse
from ..model.delete_functional_role_request import DeleteFunctionalRoleRequest
from ..model.delete_functional_role_response import DeleteFunctionalRoleResponse
from ..model.update_functional_role_request import UpdateFunctionalRoleRequest
from ..model.update_functional_role_response import UpdateFunctionalRoleResponse


class FunctionalRole(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateFunctionalRoleRequest,
               option: Optional[RequestOption] = None) -> CreateFunctionalRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateFunctionalRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateFunctionalRoleResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateFunctionalRoleRequest,
                      option: Optional[RequestOption] = None) -> CreateFunctionalRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateFunctionalRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateFunctionalRoleResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteFunctionalRoleRequest,
               option: Optional[RequestOption] = None) -> DeleteFunctionalRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteFunctionalRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteFunctionalRoleResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteFunctionalRoleRequest,
                      option: Optional[RequestOption] = None) -> DeleteFunctionalRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteFunctionalRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteFunctionalRoleResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateFunctionalRoleRequest,
               option: Optional[RequestOption] = None) -> UpdateFunctionalRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateFunctionalRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateFunctionalRoleResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateFunctionalRoleRequest,
                      option: Optional[RequestOption] = None) -> UpdateFunctionalRoleResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateFunctionalRoleResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateFunctionalRoleResponse)
        response.raw = resp

        return response
