# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.batch_get_id_user_request import BatchGetIdUserRequest
from ..model.batch_get_id_user_response import BatchGetIdUserResponse
from ..model.batch_user_request import BatchUserRequest
from ..model.batch_user_response import BatchUserResponse
from ..model.create_user_request import CreateUserRequest
from ..model.create_user_response import CreateUserResponse
from ..model.delete_user_request import DeleteUserRequest
from ..model.delete_user_response import DeleteUserResponse
from ..model.find_by_department_user_request import FindByDepartmentUserRequest
from ..model.find_by_department_user_response import FindByDepartmentUserResponse
from ..model.get_user_request import GetUserRequest
from ..model.get_user_response import GetUserResponse
from ..model.list_user_request import ListUserRequest
from ..model.list_user_response import ListUserResponse
from ..model.patch_user_request import PatchUserRequest
from ..model.patch_user_response import PatchUserResponse
from ..model.resurrect_user_request import ResurrectUserRequest
from ..model.resurrect_user_response import ResurrectUserResponse
from ..model.update_user_id_user_request import UpdateUserIdUserRequest
from ..model.update_user_id_user_response import UpdateUserIdUserResponse
from ..model.update_user_request import UpdateUserRequest
from ..model.update_user_response import UpdateUserResponse


class User(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch(self, request: BatchUserRequest, option: Optional[RequestOption] = None) -> BatchUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchUserResponse = JSON.unmarshal(str(resp.content, UTF_8), BatchUserResponse)
        response.raw = resp

        return response

    async def abatch(self, request: BatchUserRequest, option: Optional[RequestOption] = None) -> BatchUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchUserResponse = JSON.unmarshal(str(resp.content, UTF_8), BatchUserResponse)
        response.raw = resp

        return response

    def batch_get_id(self, request: BatchGetIdUserRequest,
                     option: Optional[RequestOption] = None) -> BatchGetIdUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchGetIdUserResponse = JSON.unmarshal(str(resp.content, UTF_8), BatchGetIdUserResponse)
        response.raw = resp

        return response

    async def abatch_get_id(self, request: BatchGetIdUserRequest,
                            option: Optional[RequestOption] = None) -> BatchGetIdUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchGetIdUserResponse = JSON.unmarshal(str(resp.content, UTF_8), BatchGetIdUserResponse)
        response.raw = resp

        return response

    def create(self, request: CreateUserRequest, option: Optional[RequestOption] = None) -> CreateUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateUserResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateUserResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateUserRequest, option: Optional[RequestOption] = None) -> CreateUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateUserResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateUserResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteUserRequest, option: Optional[RequestOption] = None) -> DeleteUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteUserResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteUserResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteUserRequest, option: Optional[RequestOption] = None) -> DeleteUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteUserResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteUserResponse)
        response.raw = resp

        return response

    def find_by_department(self, request: FindByDepartmentUserRequest,
                           option: Optional[RequestOption] = None) -> FindByDepartmentUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: FindByDepartmentUserResponse = JSON.unmarshal(str(resp.content, UTF_8), FindByDepartmentUserResponse)
        response.raw = resp

        return response

    async def afind_by_department(self, request: FindByDepartmentUserRequest,
                                  option: Optional[RequestOption] = None) -> FindByDepartmentUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: FindByDepartmentUserResponse = JSON.unmarshal(str(resp.content, UTF_8), FindByDepartmentUserResponse)
        response.raw = resp

        return response

    def get(self, request: GetUserRequest, option: Optional[RequestOption] = None) -> GetUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetUserResponse = JSON.unmarshal(str(resp.content, UTF_8), GetUserResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetUserRequest, option: Optional[RequestOption] = None) -> GetUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetUserResponse = JSON.unmarshal(str(resp.content, UTF_8), GetUserResponse)
        response.raw = resp

        return response

    def list(self, request: ListUserRequest, option: Optional[RequestOption] = None) -> ListUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListUserResponse = JSON.unmarshal(str(resp.content, UTF_8), ListUserResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListUserRequest, option: Optional[RequestOption] = None) -> ListUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListUserResponse = JSON.unmarshal(str(resp.content, UTF_8), ListUserResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchUserRequest, option: Optional[RequestOption] = None) -> PatchUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchUserResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchUserResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchUserRequest, option: Optional[RequestOption] = None) -> PatchUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchUserResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchUserResponse)
        response.raw = resp

        return response

    def resurrect(self, request: ResurrectUserRequest, option: Optional[RequestOption] = None) -> ResurrectUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ResurrectUserResponse = JSON.unmarshal(str(resp.content, UTF_8), ResurrectUserResponse)
        response.raw = resp

        return response

    async def aresurrect(self, request: ResurrectUserRequest,
                         option: Optional[RequestOption] = None) -> ResurrectUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ResurrectUserResponse = JSON.unmarshal(str(resp.content, UTF_8), ResurrectUserResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateUserRequest, option: Optional[RequestOption] = None) -> UpdateUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateUserResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateUserResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateUserRequest, option: Optional[RequestOption] = None) -> UpdateUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateUserResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateUserResponse)
        response.raw = resp

        return response

    def update_user_id(self, request: UpdateUserIdUserRequest,
                       option: Optional[RequestOption] = None) -> UpdateUserIdUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateUserIdUserResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateUserIdUserResponse)
        response.raw = resp

        return response

    async def aupdate_user_id(self, request: UpdateUserIdUserRequest,
                              option: Optional[RequestOption] = None) -> UpdateUserIdUserResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateUserIdUserResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateUserIdUserResponse)
        response.raw = resp

        return response
