# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .background_check_report_object import BackgroundCheckReportObject


class BackgroundCheck(object):
    _types = {
        "id": str,
        "package": int,
        "status": int,
        "created_time": str,
        "modified_time": str,
        "target_id": str,
        "outcome": int,
        "report": BackgroundCheckReportObject,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.package: Optional[int] = None
        self.status: Optional[int] = None
        self.created_time: Optional[str] = None
        self.modified_time: Optional[str] = None
        self.target_id: Optional[str] = None
        self.outcome: Optional[int] = None
        self.report: Optional[BackgroundCheckReportObject] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BackgroundCheckBuilder":
        return BackgroundCheckBuilder()


class BackgroundCheckBuilder(object):
    def __init__(self) -> None:
        self._background_check = BackgroundCheck()

    def id(self, id: str) -> "BackgroundCheckBuilder":
        self._background_check.id = id
        return self

    def package(self, package: int) -> "BackgroundCheckBuilder":
        self._background_check.package = package
        return self

    def status(self, status: int) -> "BackgroundCheckBuilder":
        self._background_check.status = status
        return self

    def created_time(self, created_time: str) -> "BackgroundCheckBuilder":
        self._background_check.created_time = created_time
        return self

    def modified_time(self, modified_time: str) -> "BackgroundCheckBuilder":
        self._background_check.modified_time = modified_time
        return self

    def target_id(self, target_id: str) -> "BackgroundCheckBuilder":
        self._background_check.target_id = target_id
        return self

    def outcome(self, outcome: int) -> "BackgroundCheckBuilder":
        self._background_check.outcome = outcome
        return self

    def report(self, report: BackgroundCheckReportObject) -> "BackgroundCheckBuilder":
        self._background_check.report = report
        return self

    def build(self) -> "BackgroundCheck":
        return self._background_check
