# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class BpRoleOrganization(object):
    _types = {
        "role_key": str,
        "department_id": str,
        "work_location_id": str,
    }

    def __init__(self, d=None):
        self.role_key: Optional[str] = None
        self.department_id: Optional[str] = None
        self.work_location_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BpRoleOrganizationBuilder":
        return BpRoleOrganizationBuilder()


class BpRoleOrganizationBuilder(object):
    def __init__(self) -> None:
        self._bp_role_organization = BpRoleOrganization()

    def role_key(self, role_key: str) -> "BpRoleOrganizationBuilder":
        self._bp_role_organization.role_key = role_key
        return self

    def department_id(self, department_id: str) -> "BpRoleOrganizationBuilder":
        self._bp_role_organization.department_id = department_id
        return self

    def work_location_id(self, work_location_id: str) -> "BpRoleOrganizationBuilder":
        self._bp_role_organization.work_location_id = work_location_id
        return self

    def build(self) -> "BpRoleOrganization":
        return self._bp_role_organization
